<?php

namespace App\Modules\Commission\Entities;

use Illuminate\Database\Eloquent\Model;

class Commission extends Model 
{

    protected $table = 'commissions';
    public $timestamps = true;
    protected $fillable = array('amount', 'commission_percentage', 'commissionable_id', 'transaction_id', 'installment_id', 'commissionable_type');

    public function commissionable()
    {
        return $this->morphTo();
    }

    public function transaction()
    {
        return $this->belongsTo('App\Models\Transaction');
    }

    public function installment()
    {
        return $this->belongsTo('App\Models\Merchant');
    }

}